#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;

struct Edge {
  int to, c, back;
  Edge() {}
  Edge(int to, int c, int back) : to(to), c(c), back(back) {}
};

int t;
vector <vector <Edge> > graph;
vector <bool> visited;

bool dfs(int v) {
  if (v == t) {
    return true;
  }

  visited[v] = true;
  
  for (auto it = graph[v].begin(); it != graph[v].end(); ++it) {
    auto &i = *it;
  //for (auto &i : graph[v]) {
    if (!visited[i.to] && i.c == 1) {
      if (dfs(i.to)) {
        i.c = 0;
        graph[i.to][i.back].c++;
        return true;
      }
    }
  }
  return false;
}

bool back_dfs(int v) {
  if (v == t) {
    return true;
  }

  visited[v] = true;
  
  for (auto it = graph[v].begin(); it != graph[v].end(); ++it) {
    auto &i = *it;
 // for (auto &i : graph[v]) {
    if (!visited[i.to] && i.c == 1) {
      if (back_dfs(i.to)) {
       // i.c = 0;
       // graph[i.to][back].c++;
        return true;
      }
    }
  }
  return false;
}

int main() {

  while (true) {
    int n, m, s;
    cin >> n >> m >> s >> t;
    if (!n && !m && !s && !t) {
      return 0;
    }
    --s; --t;
    graph.clear();
    graph.resize(n);
    visited.resize(n);

    vector <pair <int, int> > edges(m);
    
    for (int i = 0; i != m; ++i) {
      int a, b;
      cin >> a >> b;
      --a; --b;

      graph[a].push_back(Edge(b, 1, graph[b].size()));
      graph[b].push_back(Edge(a, 0, graph[a].size() - 1));

      edges[i] = make_pair(a, graph[a].size() - 1);
    }

  int answer = 0, to = graph[s].size();

  for (int i = 0; i != to; ++i) {
 //   dfs(s);
    visited.assign(n, false);
    if (dfs(s)) {
      ++answer;
    } else {
      break;
    }
  }

  int count = 0;
  //for (int i = 0; i != n; ++i) {
  for (auto it = edges.begin(); it != edges.end(); ++it) {
      auto &j = graph[it->first][it->second];
      if (j.c == 0) continue;

   // for (auto &j : graph[i]) {
      j.c = 1 - j.c;
      graph[j.to][j.back].c = 1 - graph[j.to][j.back].c;

      visited.assign(n, false);
      if (back_dfs(s)) ++count;                   

      j.c = 1 - j.c;
      graph[j.to][j.back].c = 1 - graph[j.to][j.back].c;
    }
//  }
  
    if (count) ++answer;
    cout << answer << ' ' << count << '\n';
  }
  return 0;
}